package w83a.w83aUtilidadesComunes;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;


import n38c.exe.N38API;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import es.ejie.frmk.infraestructura.seguridad.Q70GestorSeguridad;
import es.ejie.frmk.infraestructura.seguridad.Q70InformacionSeguridadUsuario;
import es.ejie.frmk.infraestructura.seguridad.Q70LogonException;
import es.ejie.frmk.infraestructura.seguridad.Q70SeguridadException;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;




/**
 * 
 * @author 
 *
 */
public abstract class W83aUtilidadesN38API{
	
	static Document xmlPersona = null;//NOPMD
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static List getParameters(HttpServletRequest request, String parameter)
	  throws TransformerException {
		 
		  try {
			  W83aClsTrazas.trazaError(null,"en getParameters",null );
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  W83aClsTrazas.trazaError(null,"gestorSeguridad="+gestorSeguridad,null );
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);
			  W83aClsTrazas.trazaError(null,"infUsuario="+infUsuario,null );
			  
			  W83aClsTrazas.trazaError(null,"resultado="+(Vector)infUsuario.getSessionSecurityInf(parameter),null );

	    	return (Vector)infUsuario.getSessionSecurityInf(parameter);  
		  } catch (Q70SeguridadException e) {
			
			  W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  } catch (Q70LogonException e) {
		
			  W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  }
	  }
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static String getSessionXML(HttpServletRequest request)
	  throws TransformerException {
		  
		  try {
			  W83aClsTrazas.trazaError(null,"dentro de getSessionXML",null );
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  W83aClsTrazas.trazaError(null,"gestorSeguridad="+gestorSeguridad,null );
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);
			  W83aClsTrazas.trazaError(null,"infUsuario="+infUsuario,null );

			  OutputFormat format    = new OutputFormat (infUsuario.getXLNESessionTolkit().n38ItemSesion()); 
			  W83aClsTrazas.trazaError(null,"format="+format,null );
		      StringWriter stringOut = new StringWriter ();    
		      W83aClsTrazas.trazaError(null,"stringOut="+stringOut,null );
		      XMLSerializer serial   = new XMLSerializer (stringOut, 
		                                                  format);
		      W83aClsTrazas.trazaError(null,"serial="+serial,null );
		      try {
				serial.serialize(infUsuario.getXLNESessionTolkit().n38ItemSesion());
				W83aClsTrazas.trazaError(null,"despus del serialize",null );
			} catch (IOException e) {
				
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			}
		      // Display the XML

		     /* int i=0;
		      while (i<stringOut.toString().length()){
		    	  if (i<stringOut.toString().length()-100){
		    		  W83aClsTrazas.trazaError(null,"stringOut.toString()="+stringOut.toString().substring(i, i+100),null);
		    		  i=i+100;
		    	  }
		    	  else{
		    		  W83aClsTrazas.trazaError(null,"stringOut.toString()="+stringOut.toString().substring(i, stringOut.toString().length()),null );
		    	  }
		    	  
		      }*/
		      W83aClsTrazas.trazaError(null,"stringOut.toString()="+stringOut.toString(),null );
				  return stringOut.toString();  

		  } catch (Q70SeguridadException e) {

			  W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  } catch (Q70LogonException e) {
			 
			  W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			  return null;
		  }
	  }
	  
	  /**
	   * Gets the parameters.
	   * 
	   * @param document the document
	   * @param parameter the parameter
	   * @return the parameters
	   * @throws TransformerException the transformer exception
	   */
	  private static Document getSessionXMLDoc(HttpServletRequest request)
	  throws TransformerException {
		  W83aClsTrazas.trazaError(null,"despus de getSessionXMLDoc",null );

		  try {
			  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
			  W83aClsTrazas.trazaError(null,"gestorSeguridad="+gestorSeguridad,null );
			  Q70InformacionSeguridadUsuario infUsuario = gestorSeguridad.createSecurityUserInfo(request);
			  W83aClsTrazas.trazaError(null,"infUsuario="+infUsuario,null );
			  
			  W83aClsTrazas.trazaError(null,"infUsuario.getXLNESessionTolkit().n38ItemSesion()="+infUsuario.getXLNESessionTolkit().n38ItemSesion(),null );

				return infUsuario.getXLNESessionTolkit().n38ItemSesion();
			} catch (Q70SeguridadException e) {
				
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
				return null;
			} catch (Q70LogonException e) {
				
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
				return null;
			}  

	  }
  
	  

	  public static String getIdiomaXLnets(HttpServletRequest request){
		    try {
				return (String)getParameters(request, "n38idioma").get(0);				
			} catch (TransformerException e1) {
			
				W83aClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
				return "";
			}
	  }
	  
	  public static String getNombrePersona(HttpServletRequest request,String dni){
		  W83aClsTrazas.trazaError(null,"dentro de getNombrePersona="+dni,null );
		  Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
		  W83aClsTrazas.trazaError(null,"gestorSeguridad="+gestorSeguridad,null );
			Q70InformacionSeguridadUsuario infUsuario;
			try {
				infUsuario = gestorSeguridad.createSecurityUserInfo(request);
				W83aClsTrazas.trazaError(null,"infUsuario="+infUsuario,null );
				N38API sessionTolkit = infUsuario.getXLNESessionTolkit();
				W83aClsTrazas.trazaError(null,"sessionTolkit="+sessionTolkit,null );
			
		  if(null==xmlPersona){
			  W83aClsTrazas.trazaError(null,"xmlPersona null",null );
			  xmlPersona  = sessionTolkit.n38ItemObtenerPersonas("dni="+dni);
			  W83aClsTrazas.trazaError(null,"xmlPersona"+xmlPersona,null );
		  }
		  String querie = "//parent::elemento/parametro[@id=\"givenname\"]/valor/text()";
		  W83aClsTrazas.trazaError(null,"querie"+querie,null );
		  NodeList nodeNOMBRE = XPathAPI.selectNodeList(xmlPersona, querie);
		  W83aClsTrazas.trazaError(null,"nodeNOMBRE="+nodeNOMBRE,null );
		  W83aClsTrazas.trazaError(null,"nodeNOMBRE.item(0).getNodeValue()="+nodeNOMBRE.item(0).getNodeValue(),null );
		  return nodeNOMBRE.item(0).getNodeValue();
			} catch (Q70SeguridadException e) {
				
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			} catch (Q70LogonException e) {
				
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			}catch (TransformerException e1) {
				
				W83aClsTrazas.trazaError(null,e1.getLocalizedMessage(),e1);
			}
		  
		  return "";
	  }
	  
	  public static W83aUsuarioXLNetsBean getUsuarioXLNets(HttpServletRequest request)
	  throws TransformerException{
		  W83aClsTrazas.trazaError(null,"dentro de getUsuarioXLNets",null );
		  
		  W83aUsuarioXLNetsBean usuarioBean = new W83aUsuarioXLNetsBean();
		  
		  W83aClsTrazas.trazaError(null,"usuarioBean creado",null );
		  
		  W83aClsTrazas.trazaError(null,"usuarioBean creado antes de if",null );
		  
		  if(null!=getParameters(request, "n38idioma")&&getParameters(request, "n38idioma").size()>0){
			  W83aClsTrazas.trazaError(null,"Entrado if",null );
			  usuarioBean.setIdioma((String)getParameters(request, "n38idioma").get(0));
			  W83aClsTrazas.trazaError(null,"idioma="+usuarioBean.getIdioma(),null );
			  usuarioBean.setDniUsuario((String)getParameters(request, "dni").get(0));
			  W83aClsTrazas.trazaError(null,"dniUsuario="+usuarioBean.getDniUsuario(),null );
			  //usuarioBean.setNombrePersona((String)getNombrePersona(request, usuarioBean.getDniUsuario()));
			  W83aClsTrazas.trazaError(null,"nombrePersona="+usuarioBean.getNombrePersona(),null );
			  usuarioBean.setPerfilXLNets(getParameters(request, "n38perfiles"));
			  W83aClsTrazas.trazaError(null,"perfilXLNets="+usuarioBean.getPerfilXLNets(),null );
			  usuarioBean.setIdUsuario((String)getParameters(request, "n38personauid").get(0));
			  W83aClsTrazas.trazaError(null,"idUsuario="+usuarioBean.getIdUsuario(),null );
			  usuarioBean.setSessionTokenXLNets(getSessionXML(request));
			  W83aClsTrazas.trazaError(null,"despus de getSessionTokenXLNets",null );
			  usuarioBean.setSessionTokenXLNetsDoc(getSessionXMLDoc(request));
			  W83aClsTrazas.trazaError(null,"despus de getSessionXMLDoc",null );
			  usuarioBean.setXmlThirdPartySession(getThirdPartySession(request));
			  W83aClsTrazas.trazaError(null,"despus de getThirdPartySession",null );
			  
			  List listaLogin = getParameters(request, "n38login"); 
			  usuarioBean.setLoginXLNets((listaLogin.size() == 0) ? null : (String) listaLogin.get(0));	
			  W83aClsTrazas.traza(usuarioBean,"n38idioma->"+usuarioBean.getIdioma());			  
			  W83aClsTrazas.traza(usuarioBean,"dni->"+usuarioBean.getDniUsuario());			  
			  W83aClsTrazas.traza(usuarioBean,"id->"+usuarioBean.getIdUsuario());			  
			  W83aClsTrazas.traza(usuarioBean,"n38perfiles->"+usuarioBean.getPerfilXLNets());			  
			  W83aClsTrazas.traza(usuarioBean,"n38login->"+(String) listaLogin.get(0));
			  W83aClsTrazas.traza(usuarioBean,"n38personauid->"+usuarioBean.getIdUsuario());
			  
		  }else{
			  W83aClsTrazas.trazaError(null,"Entrado else",null );
			  usuarioBean = null;
		  }
		  return usuarioBean;
	  }
	  
	  public static boolean comprobarExistenciaUsuarioXLNets(HttpServletRequest request)
	  throws TransformerException{
		  
		  W83aClsTrazas.trazaError(null, "idioma user->"+getParameters(request, "n38idioma"), null);
		  
		  return(null!=getParameters(request, "n38idioma")&&getParameters(request, "n38idioma").size()>0);
		 
	  }
	  
		
		 public static String XLNetURL(HttpServletRequest req, String mod, String action) throws Exception {
			 	W83aClsTrazas.trazaError(null,"Dentro de XLNetURL",null );
			 	W83aClsTrazas.trazaError(null,Q70ListenerUtils.getApplicationProperty("URL_ACCESO"),null );
		        String urlXLNet = Q70ListenerUtils.getApplicationProperty("URL_ACCESO");
		        W83aClsTrazas.trazaError(null,"urlXLNet="+urlXLNet,null );
	            StringBuffer urlXLNetb = new StringBuffer(urlXLNet);
	            W83aClsTrazas.trazaError(null,"urlXLNetb="+urlXLNetb,null );
		        String ctxPath = req.getContextPath();
		        W83aClsTrazas.trazaError(null,"ctxPath="+ctxPath,null );

		        String portal = req.getParameter("R01HPortal");
		        W83aClsTrazas.trazaError(null,"portal="+portal,null );
		        String pagina = req.getParameter("R01HPage");
		        W83aClsTrazas.trazaError(null,"pagina="+pagina,null );
		        String idioma = req.getParameter("R01HLang");  
		        W83aClsTrazas.trazaError(null,"idioma="+idioma,null );
		        if (portal!=null && pagina!=null && idioma!=null)
		        {   urlXLNetb.append("/").append(portal).append("-").append(pagina).append("/").append(idioma).append(ctxPath).append(mod).append(action);}
		        else
		        {   urlXLNetb.append(ctxPath).append(mod).append(action);}
		        W83aClsTrazas.trazaError(null,"urlXLNetb.toString()="+urlXLNetb.toString(),null );
		        return urlXLNetb.toString();

		    }		 
			
			/**
			 * Funcin que devuelve la provincia en funcin de la delegacin
			 * Si no pertenece a ninguna provincia se supone de servicios centrales y devuelve 
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirProvinciaDelegacion(List codDelegacion){
				

				if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)){
					return W83aClsConstantes.CONSTANTE_ALAVA;			
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)){
					return W83aClsConstantes.CONSTANTE_ALAVA;			
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)){
					return W83aClsConstantes.CONSTANTE_GIPUZKOA;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)){
					return W83aClsConstantes.CONSTANTE_GIPUZKOA;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)){
					return W83aClsConstantes.CONSTANTE_BIZKAIA;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83aClsConstantes.CONSTANTE_BIZKAIA;
				}
				
				return "";
			}
			
			
			/**
			 * Mira a ver si tiene permisos de Administrador o de consulta
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirAdministradorConsulta(List codDelegacion){
				if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83aClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)||
						codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)||
						codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)
						){
					return W83aClsConstantes.PERMISO_ADMINISTRADOR;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)||
						codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)||
						codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83aClsConstantes.PERMISO_CONSULTA;			
				}
				return "";
			}
			
			/**
			 * Funcin que devuelve la provincia en funcin de la delegacin
			 * Si no pertenece a ninguna provincia se supone de servicios centrales y devuelve 
			 * @param codDelegacion
			 * @return 
			 */
			public static String elegirServiciosCentralosODelegacion(List codDelegacion){

				
				if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES)){
					return W83aClsConstantes.CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA;			
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA;			
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA;			
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_ALAVA;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA;
				}else if(codDelegacion.contains(W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA)){
					return W83aClsConstantes.CONSTANTE_PERMISO_CONSULTA_BIZKAIA;
				}

				
				return "";
			}
			
			
		/**
		   * retorna la politica de la txartela
		   * @param  request HttpServletRequest
		   * @return String
		   * @throws TransformerException 
		   * @throws IOException 
		   * @throws Exception
		   */
		  public static String getThirdPartySession(HttpServletRequest request)  {
			  try{
				  N38API n38API = new N38API(request);  
				  TransformerFactory tf = TransformerFactory.newInstance();
				  Transformer transformer = tf.newTransformer();
				  transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
				  StringWriter writer = new StringWriter();
				  transformer.transform(new DOMSource(n38API.n38ItemSesion()), new StreamResult(writer));
				  String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
				  
				   
				  String filtro="//parent::elemento/parametro[@id=\"n38b64thirdpartyassertion\"]/valor/text()";
				  NodeList  nodeLi=XPathAPI.selectNodeList(n38API.n38ItemSesion(), filtro);
				  String thirdPartyaSsertionB64=nodeLi.item(0).getNodeValue();
				  String thirdPartySessionXML = null;
				  if(thirdPartyaSsertionB64!=null  && !"".equals(thirdPartyaSsertionB64) && !"NO".equals(thirdPartyaSsertionB64)){
					    thirdPartySessionXML = W83ABase64.decodeToString(thirdPartyaSsertionB64);
				  }
				  return thirdPartySessionXML;
			  
				} catch (Exception e) {
					
					W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
					return null;
				}  
			  
		  }
}